# AEO WP Plugin - Premium Features

## Overview
This plugin has been upgraded to a premium monetizable WordPress plugin with licensing, quota management, and plan-based features.

## Features Implemented

### 1. Plans & Pricing ✅
Four plan tiers with different audit limits:

- **FREE**: 5 audits/month
- **WEEKLY**: 25 audits/week  
- **PRO**: 150 audits/month
- **ENTERPRISE**: 500 audits/month

### 2. Dashboard Enhancements ✅
- Current plan badge display
- Usage progress bar showing remaining audits
- Audit count (used/total)
- Reset date information
- "Upgrade Anytime" button linking to https://aeowpplugin.com/pricing

### 3. License Activation UI ✅
Settings page includes:
- License key input field
- Activate / Deactivate buttons
- Status badge (Active / Inactive / Expired / Invalid)
- License details table showing:
  - Plan type
  - Status
  - Expiration date
  - Quota usage

### 4. Mock License Validation ✅
Works immediately without backend API:

**License Key Prefixes:**
- `FREE-` → Free plan (5/month)
- `WEEKLY-` → Weekly plan (25/week)
- `PRO-` → Pro plan (150/month)
- `ENT-` → Enterprise plan (500/month)

**Test Keys:**
- FREE-TEST-001
- WEEKLY-TEST-001
- PRO-TEST-001
- ENT-TEST-001

### 5. Quota & Usage Enforcement ✅
Before each scan:
- Validates license status
- Checks remaining quota
- Blocks scan if limit reached
- Shows upgrade message with button

Automatic quota reset:
- Weekly plans: Every 7 days
- Monthly plans: First day of each month

### 6. Future-Ready API Client ✅
Structured for easy backend integration:
- `POST /api/license/validate` - License validation
- `POST /api/scan` - Perform audit scan

**Fallback Logic:**
- Tries real API first
- Falls back to mock responses if API unavailable
- Seamless transition when backend is ready

### 7. Clean Code Structure ✅

```
aeowpplugin/
├── aeowpplugin.php (main plugin file)
├── includes/
│   ├── class-license-manager.php (license validation & activation)
│   ├── class-quota-manager.php (usage tracking & limits)
│   ├── class-api-client.php (API communication with fallback)
│   ├── helpers.php (utility functions)
│   ├── api-handler.php (AJAX handlers)
│   └── rate-limit.php (rate limiting)
├── admin/
│   ├── dashboard.php (main dashboard UI)
│   └── settings.php (settings page UI)
└── assets/
    ├── js/
    │   └── admin.js (frontend JavaScript)
    └── css/
        └── admin.css (premium styling)
```

## How It Works

### License Activation Flow
1. User enters license key in Settings
2. Click "Activate License"
3. Plugin validates key (mock or API)
4. Stores license data in WordPress options
5. Updates quota limits based on plan
6. Page reloads showing active license

### Scan Flow with Quota Check
1. User clicks "Analyze Now"
2. Plugin checks license status
3. Validates quota remaining
4. If quota exceeded:
   - Blocks scan
   - Shows error message
   - Displays "Upgrade Now" button
5. If quota available:
   - Performs scan
   - Increments usage counter
   - Updates quota display

### Quota Reset Logic
- Stored in WordPress options: `aeowpplugin_quota_data`
- Contains: `used`, `last_reset`
- Checks on each scan if reset needed
- Automatically resets based on plan period

## Installation

1. Upload `aeowpplugin` folder to `/wp-content/plugins/`
2. Activate plugin through WordPress admin
3. Go to AEO WP → Settings
4. Enter a test license key (e.g., `PRO-TEST-001`)
5. Click "Activate License"
6. Return to Dashboard to see plan and usage

## Testing

### Test License Keys
Use these keys to test different plans:

```
FREE-TEST-001    → Free plan (5/month)
WEEKLY-TEST-001  → Weekly plan (25/week)
PRO-TEST-001     → Pro plan (150/month)
ENT-TEST-001     → Enterprise plan (500/month)
```

### Test Quota Limits
1. Activate a FREE license
2. Run 5 scans
3. Try 6th scan - should be blocked
4. See upgrade message with button

## Backend Integration (Future)

When your backend is ready at `https://aeowpplugin.com/api`:

### License Validation Endpoint
```
POST /api/license/validate
Content-Type: application/json

{
  "licenseKey": "PRO-XXXX-XXXX"
}

Response:
{
  "valid": true,
  "plan": "pro",
  "status": "active",
  "expires_at": "2026-12-31",
  "quota": {
    "period": "month",
    "limit": 150,
    "used": 3,
    "remaining": 147
  }
}
```

### Scan Endpoint
```
POST /api/scan
Content-Type: application/json

{
  "url": "https://example.com",
  "licenseKey": "PRO-XXXX-XXXX"
}

Response:
{
  "success": true,
  "data": {
    "score": 85,
    "status": "Good",
    "breakdown": {...},
    "issues": [...],
    "recommendations": [...]
  }
}
```

## WordPress Options Used

- `aeowpplugin_license_key` - Current license key
- `aeowpplugin_license_data` - Full license data
- `aeowpplugin_license_activated_at` - Activation timestamp
- `aeowpplugin_quota_data` - Usage tracking
- `aeowpplugin_last_scan` - Last scan results

## Support

For issues or questions:
- Documentation: https://aeowpplugin.com/docs
- Support: https://aeowpplugin.com/support
- Pricing: https://aeowpplugin.com/pricing
