<?php
/**
 * Debug Script for AEO WP Plugin
 * 
 * Upload this file to your WordPress root directory and access it via:
 * http://yourdomain.com/debug.php
 * 
 * This will help identify what's causing the HTTP 500 error
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>AEO WP Plugin Debug</h1>";
echo "<hr>";

// Check if WordPress is loaded
if (!defined('ABSPATH')) {
    // Try to load WordPress
    $wp_load_paths = array(
        __DIR__ . '/wp-load.php',
        __DIR__ . '/../wp-load.php',
        __DIR__ . '/../../wp-load.php',
        __DIR__ . '/../../../wp-load.php',
    );
    
    $wp_loaded = false;
    foreach ($wp_load_paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            $wp_loaded = true;
            echo "<p>✅ WordPress loaded from: " . $path . "</p>";
            break;
        }
    }
    
    if (!$wp_loaded) {
        die("<p>❌ Could not load WordPress. Please move this file to your WordPress root directory.</p>");
    }
}

echo "<h2>1. Plugin Path Check</h2>";
$plugin_path = WP_PLUGIN_DIR . '/aeowpplugin';
echo "<p>Plugin directory: <code>" . $plugin_path . "</code></p>";

if (is_dir($plugin_path)) {
    echo "<p>✅ Plugin directory exists</p>";
} else {
    echo "<p>❌ Plugin directory NOT found!</p>";
    die();
}

echo "<h2>2. Required Files Check</h2>";
$required_files = array(
    'aeowpplugin.php',
    'includes/class-license-manager.php',
    'includes/class-quota-manager.php',
    'includes/class-api-client.php',
    'includes/helpers.php',
    'includes/api-handler.php',
    'includes/rate-limit.php',
    'admin/dashboard.php',
    'admin/settings.php',
    'assets/css/admin.css',
    'assets/js/admin.js',
);

$all_files_exist = true;
foreach ($required_files as $file) {
    $filepath = $plugin_path . '/' . $file;
    if (file_exists($filepath)) {
        echo "<p>✅ <code>" . $file . "</code></p>";
    } else {
        echo "<p>❌ <code>" . $file . "</code> - MISSING!</p>";
        $all_files_exist = false;
    }
}

if (!$all_files_exist) {
    die("<p><strong>Some files are missing. Please re-upload the plugin.</strong></p>");
}

echo "<h2>3. Class Loading Test</h2>";
try {
    require_once $plugin_path . '/includes/class-license-manager.php';
    echo "<p>✅ AEOWPPlugin_License_Manager loaded</p>";
    
    require_once $plugin_path . '/includes/class-quota-manager.php';
    echo "<p>✅ AEOWPPlugin_Quota_Manager loaded</p>";
    
    require_once $plugin_path . '/includes/class-api-client.php';
    echo "<p>✅ AEOWPPlugin_API_Client loaded</p>";
    
    require_once $plugin_path . '/includes/helpers.php';
    echo "<p>✅ helpers.php loaded</p>";
    
    require_once $plugin_path . '/includes/api-handler.php';
    echo "<p>✅ AEOWPPlugin_API_Handler loaded</p>";
    
} catch (Exception $e) {
    echo "<p>❌ Error loading classes: " . $e->getMessage() . "</p>";
    die();
}

echo "<h2>4. Class Existence Check</h2>";
$classes = array(
    'AEOWPPlugin_License_Manager',
    'AEOWPPlugin_Quota_Manager',
    'AEOWPPlugin_API_Client',
    'AEOWPPlugin_API_Handler',
);

foreach ($classes as $class) {
    if (class_exists($class)) {
        echo "<p>✅ <code>" . $class . "</code> exists</p>";
    } else {
        echo "<p>❌ <code>" . $class . "</code> NOT found!</p>";
    }
}

echo "<h2>5. Function Existence Check</h2>";
$functions = array(
    'aeowpplugin_get_plan_name',
    'aeowpplugin_get_plan_badge_class',
    'aeowpplugin_format_date',
    'aeowpplugin_get_upgrade_url',
    'aeowpplugin_is_premium',
);

foreach ($functions as $function) {
    if (function_exists($function)) {
        echo "<p>✅ <code>" . $function . "()</code> exists</p>";
    } else {
        echo "<p>❌ <code>" . $function . "()</code> NOT found!</p>";
    }
}

echo "<h2>6. Test License Manager</h2>";
try {
    $license_data = AEOWPPlugin_License_Manager::get_license_data();
    echo "<p>✅ License Manager working</p>";
    echo "<pre>" . print_r($license_data, true) . "</pre>";
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<h2>7. Test Quota Manager</h2>";
try {
    $quota = AEOWPPlugin_Quota_Manager::get_quota_status();
    echo "<p>✅ Quota Manager working</p>";
    echo "<pre>" . print_r($quota, true) . "</pre>";
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<h2>8. Test Dashboard Rendering</h2>";
try {
    ob_start();
    include $plugin_path . '/admin/dashboard.php';
    $output = ob_get_clean();
    
    if (strlen($output) > 100) {
        echo "<p>✅ Dashboard renders successfully (" . strlen($output) . " bytes)</p>";
    } else {
        echo "<p>⚠️ Dashboard output seems too short</p>";
        echo "<pre>" . htmlspecialchars($output) . "</pre>";
    }
} catch (Exception $e) {
    echo "<p>❌ Error rendering dashboard: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h2>✅ All Tests Complete!</h2>";
echo "<p>If all tests passed, the plugin should work. Try accessing the plugin dashboard again.</p>";
echo "<p><a href='/wp-admin/admin.php?page=aeowpplugin'>Go to Plugin Dashboard</a></p>";
