<?php
/**
 * License & Premium Features Handler for AEO WP Plugin
 *
 * @package AEOWPPlugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * AEOWPPlugin_License class
 */
class AEOWPPlugin_License {

	/**
	 * Check if premium license is active
	 *
	 * @return bool
	 */
	public static function is_premium() {
		$license = get_option( 'aeowpplugin_license' );
		return ! empty( $license ) && self::is_license_valid( $license );
	}

	/**
	 * Validate license
	 *
	 * @param string $license License key.
	 * @return bool
	 */
	public static function is_license_valid( $license ) {
		// In production, validate against licensing server
		// For now, accept any non-empty license
		return ! empty( $license );
	}

	/**
	 * Get upgrade URL
	 *
	 * @return string
	 */
	public static function get_upgrade_url() {
		return 'https://aeowpplugin.com/pricing';
	}

	/**
	 * Get plan details
	 *
	 * @return array
	 */
	public static function get_plan_limits() {
		$is_premium = self::is_premium();

		return array(
			'scans_per_day'   => $is_premium ? 1000 : 10,
			'scan_frequency'  => $is_premium ? 'unlimited' : 'limited',
			'support'         => $is_premium ? 'priority' : 'community',
			'api_priority'    => $is_premium ? 'high' : 'standard',
		);
	}
}
